package com.ejie.ab04b.dao.custom;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.DocumentoOS3DaoImpl;
import com.ejie.ab04b.model.DatosEnvioPostal;
import com.ejie.ab04b.model.DocumentoOS3;
import com.ejie.ab04b.model.TareaOS3;
import com.ejie.ab04b.model.TipoDocumento;
import com.ejie.ab04b.model.TramiteOS3;
import com.ejie.ab04b.util.DaoUtils;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * Ab0497s00DaoImpl generated by UDA, 15-Feb-2017 09:14:46.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class DocumentoOS3CustomDaoImpl extends DocumentoOS3DaoImpl
		implements DocumentoOS3CustomDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_DOCUMENTO_097 IDDOCUMENTO097, t1.ID_TRAMITE_OS3_097 IDTRAMITEOS3097, t1.ORIGEN_097 ORIGEN097, t1.FECHA_DOC_097 FECHADOC097, t1.RUTA_PIF_097 RUTAPIF097, t1.NOMBRE_DOC_097 NOMBREDOC097, t1.OID_DOKUSI_097 OIDDOKUSI097, t1.ID_TIPO_DOC_097 IDTIPODOC097, t1.FORMATO_APORT_097 FORMATOAPORT097, t1.ID_TAREA_CONT_097 IDTAREACONT097, t1.ID_DATOS_ENVIO_POSTAL_097 IDDATOSENVIOPOSTAL097, t1.DESCRIPCION_ES_091 DESCRIPCIONES091, t1.DESCRIPCION_EU_091 DESCRIPCIONEU091, t1.TIPO_DOKUSI_091 TIPODOKUSI091, t1.ASUNTO_DOKUSI_091 ASUNTODOKUSI091, t1.APORT_GEN_091 APORTGEN091 FROM VDOCUMENTO_OS3_TIPO t1 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DocumentoOS3> rwMap = new RowMapper<DocumentoOS3>() {
		public DocumentoOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			DocumentoOS3 documento = new DocumentoOS3(
					resultSet.getLong("IDDOCUMENTO097"),
					resultSet.getInt("ORIGEN097"),
					resultSet.getDate("FECHADOC097"),
					resultSet.getString("RUTAPIF097"),
					resultSet.getString("NOMBREDOC097"),
					resultSet.getString("OIDDOKUSI097"), null, null,
					resultSet.getString("FORMATOAPORT097"), null,
					new TramiteOS3(resultSet.getLong("IDTRAMITEOS3097")));

			documento.setTipoDocumento(
					new TipoDocumento(resultSet.getLong("IDTIPODOC097"),
							resultSet.getString("DESCRIPCIONES091"),
							resultSet.getString("DESCRIPCIONEU091"),
							resultSet.getString("TIPODOKUSI091"),
							resultSet.getString("ASUNTODOKUSI091"),
							resultSet.getString("APORTGEN091")));

			Long idTareaContinuar = DaoUtils.getInstance()
					.getLongNullable(resultSet, "IDTAREACONT097");
			if (idTareaContinuar != null) {
				documento.setTareaOS3Continuar(new TareaOS3(idTareaContinuar));
			}

			Long idDatosEnvioPostal = DaoUtils.getInstance()
					.getLongNullable(resultSet, "IDDATOSENVIOPOSTAL097");
			if (idTareaContinuar != null) {
				documento.setDatosEnvioPostal(
						new DatosEnvioPostal(idDatosEnvioPostal));
			}

			return documento;
		}
	};

	/**
	 * Finds a single row in the Ab0497s00 table.
	 * 
	 *  ab0497s00
	 *            Ab0497s00
	 *  Ab0497s00
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @return the documento OS 3
	 */
	@Transactional(readOnly = true)
	public DocumentoOS3 vfind(DocumentoOS3 ab0497s00) {
		StringBuilder query = new StringBuilder(
				DocumentoOS3CustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_DOCUMENTO_097 = ? ");

		List<DocumentoOS3> ab0497s00List = this.getJdbcTemplate().query(
				query.toString(), this.rwMap, ab0497s00.getIdDocumento097());
		return (DocumentoOS3) DataAccessUtils.uniqueResult(ab0497s00List);
	}

	/**
	 * Finds a list of rows in the Ab0497s00 table.
	 * 
	 *  ab0497s00
	 *            Ab0497s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0497s00>
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoOS3> vfindAll(DocumentoOS3 ab0497s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				DocumentoOS3CustomDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0497s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoOS3>) this.getJdbcTemplate()
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0497s00 entity
	 * 
	 *  ab0497s00
	 *            Ab0497s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DocumentoOS3 ab0497s00) {

		StringBuilder where = new StringBuilder(
				DocumentoOS3CustomDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0497s00 != null && ab0497s00.getIdDocumento097() != null) {
			where.append(" AND t1.ID_DOCUMENTO_097 = ?");
			params.add(ab0497s00.getIdDocumento097());
		}
		if (ab0497s00 != null && ab0497s00.getTramiteOS3() != null
				&& ab0497s00.getTramiteOS3().getIdTramite095() != null) {
			where.append(" AND t1.ID_TRAMITE_OS3_097 = ?");
			params.add(ab0497s00.getTramiteOS3().getIdTramite095());
		}
		if (ab0497s00 != null && ab0497s00.getOrigen097() != null) {
			where.append(" AND t1.ORIGEN_097 = ?");
			params.add(ab0497s00.getOrigen097());
		}
		if (ab0497s00 != null && ab0497s00.getFechaDoc097() != null) {
			where.append(" AND t1.FECHA_DOC_097 = ?");
			params.add(ab0497s00.getFechaDoc097());
		}
		if (ab0497s00 != null && ab0497s00.getRutaPif097() != null) {
			where.append(" AND t1.RUTA_PIF_097 = ?");
			params.add(ab0497s00.getRutaPif097());
		}
		if (ab0497s00 != null && ab0497s00.getNombreDoc097() != null) {
			where.append(" AND t1.NOMBRE_DOC_097 = ?");
			params.add(ab0497s00.getNombreDoc097());
		}
		if (ab0497s00 != null && ab0497s00.getOidDokusi097() != null) {
			where.append(" AND t1.OID_DOKUSI_097 = ?");
			params.add(ab0497s00.getOidDokusi097());
		}

		if (ab0497s00 != null && ab0497s00.getTipoDocumento() != null
				&& ab0497s00.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_097 = ?");
			params.add(ab0497s00.getTipoDocumento().getIdTipoDoc091());
		}
		if (ab0497s00 != null && ab0497s00.getTipoDocumento() != null
				&& ab0497s00.getTipoDocumento().getDescripcionEs091() != null) {
			where.append(" AND t1.DESCRIPCION_ES_091 = ?");
			params.add(ab0497s00.getTipoDocumento().getDescripcionEs091());
		}
		if (ab0497s00 != null && ab0497s00.getTipoDocumento() != null
				&& ab0497s00.getTipoDocumento().getDescripcionEu091() != null) {
			where.append(" AND t1.DESCRIPCION_EU_091 = ?");
			params.add(ab0497s00.getTipoDocumento().getDescripcionEu091());
		}
		if (ab0497s00 != null && ab0497s00.getTipoDocumento() != null
				&& ab0497s00.getTipoDocumento().getTipoDokusi091() != null) {
			where.append(" AND t1.TIPO_DOKUSI_091 = ?");
			params.add(ab0497s00.getTipoDocumento().getTipoDokusi091());
		}
		if (ab0497s00 != null && ab0497s00.getTipoDocumento() != null
				&& ab0497s00.getTipoDocumento().getAsuntoDokusi091() != null) {
			where.append(" AND t1.ASUNTO_DOKUSI_091 = ?");
			params.add(ab0497s00.getTipoDocumento().getAsuntoDokusi091());
		}
		if (ab0497s00 != null && ab0497s00.getTipoDocumento() != null
				&& ab0497s00.getTipoDocumento().getAportGen091() != null) {
			where.append(" AND t1.APORT_GEN_091 = ?");
			params.add(ab0497s00.getTipoDocumento().getAportGen091());
		}
		if (ab0497s00 != null && ab0497s00.getFormatoAport097() != null) {
			where.append(" AND t1.FORMATO_APORT_097 = ?");
			params.add(ab0497s00.getFormatoAport097());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
